//+------------------------------------------------------------------+
//|                                                    stoch+rsi.mq4 |
//|                        Copyright 2014, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_minimum 99.95
#property indicator_maximum 100.05
#property indicator_buffers 3
#property indicator_plots   1
//--- plot Line
#property indicator_label1  "Line"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  0

#property indicator_label2  "UP"
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrBlue
#property indicator_width2  0

#property indicator_label3  "DN"
#property indicator_type3   DRAW_ARROW
#property indicator_color3  clrRed
#property indicator_width3  0
//--- input parameters
input int      stoch_per_0=2;
input int      stoch_per_1=3;
input int      stoch_per_2=4;
input int      stoch_per_3=5;
input int      stoch_per_4=5;
input int      rsi_per_0=5;
//--- indicator buffers
double         LineBuffer[],UPBuffer[],DNBuffer[];
double LastHigh,LastLow,R;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,LineBuffer);
   SetIndexStyle(0,DRAW_LINE);
   
   SetIndexBuffer(1,UPBuffer);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,233);
   
   SetIndexBuffer(2,DNBuffer);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,234);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
    double stoch_0,stoch_1,stoch_2,stoch_3,stoch_4,rsi;
 
   int counted_bars=IndicatorCounted();
   int limit,i;

   if(counted_bars < 0)   return(-1);

   limit=Bars-counted_bars-1;
   if(counted_bars==0) limit-=2;

   if(counted_bars==0) 
     {
      LastHigh= High [limit+1];
      LastLow = Low [limit+1];
      bool Ready=false;
     }

   for(i=limit; i>=0; i--)
     {
      
      stoch_0=iStochastic(NULL,0,stoch_per_0,2,2,MODE_SMA,0,MODE_MAIN,i);
      stoch_1=iStochastic(NULL,0,stoch_per_1,2,2,MODE_SMA,0,MODE_MAIN,i);
      stoch_2=iStochastic(NULL,0,stoch_per_2,2,2,MODE_SMA,0,MODE_MAIN,i);
      stoch_3=iStochastic(NULL,0,stoch_per_3,2,2,MODE_SMA,0,MODE_MAIN,i);
      stoch_4=iStochastic(NULL,0,stoch_per_4,3,3,MODE_SMA,0,MODE_MAIN,i);
      rsi=iRSI(NULL,0,rsi_per_0,PRICE_CLOSE,i);
      
      if(stoch_0>80 && stoch_1>80 && stoch_2>80 && stoch_3>80 && rsi>70)
         LineBuffer[i]=100.02;
      else
          if(stoch_0<20 && stoch_1<20 && stoch_2<20 && stoch_3<20 && rsi<30)
            LineBuffer[i]=99.98;
          else
            LineBuffer[i]=100;
   }  
   for(i=limit; i>=0; i--)
   {  
     if(LineBuffer[i+1]==100.02 && Close[i+1]-Open[i+1] <0)DNBuffer[i]=100.04;    
     if(LineBuffer[i+1]==99.98 && Close[i+1]-Open[i+1] > 0)UPBuffer[i]=99.96;    
   }
//---- done
   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
